﻿          		  ::--::--:: SQL: Structured Query Language ::--::--::
SQL (Yapısal Sorgulama Dili), veri tabanlarını yönetmek ve sorgulamak için kullanılan bir dildir. Verilerin depolanması, güncellenmesi, silinmesi ve sorgulanması gibi işlemleri gerçekleştirmeye olanak tanır.

İlişkisel veritabanları için tasarlanan SQL, verilerin düzenli şekilde saklanmasını, organize edilmesini ve erişilmesini sağlar. SELECT, INSERT, UPDATE, DELETE gibi önceden tanımlı komutlarla veri tabanlarına erişim sağlar.

Büyük ve küçük ölçekli işletmeler tarafından yaygın olarak kullanılan SQL, 
birçok programlama dili ve veri tabanı sistemi tarafından desteklenir. 
Kullanımı kolay ve esnek bir yapıya sahip olup, birçok veri tabanı yönetim sisteminin temelini oluşturur.

/* Öğr.Gör.Dr.Ali Osman GÖKCAN
www.aliosmangokcan.com */

         ::--::--:: T-SQL ::--::--::
T-SQL (Transact-SQL), Microsoft SQL Server tarafından kullanılan bir sorgulama 
ve programlama dilidir. SQL standartlarına ek olarak, gelişmiş programlama özellikleri sunar.

T-SQLin başlıca özellikleri:

* SQL sorgularıyla veritabanı işlemlerini gerçekleştirir.
* Prosedürler, fonksiyonlar, tetikleyiciler ve saklı prosedürler gibi programlama nesneleriyle yapılandırılmış programlama imkanı sağlar.
* Değişkenler, koşullu ifadeler, döngüler ve kontrol yapıları içerir.
* Dizinleme, tablolar ve dizeler gibi çeşitli veri türlerini destekler.
* Veritabanı yönetim sistemi tarafından optimize edilerek yüksek performans sağlar.
* Microsoft SQL Server ile güçlü bir entegrasyona sahip olan T-SQL, güvenilir ve yüksek performanslı uygulamalar geliştirmek için etkili bir araçtır.

      ::--::--:: PL/SQL - Oracle tarafından geliştirilmiştir. ::--::--::
PL/SQL (Procedural Language/Structured Query Language), Oracle veritabanı yönetim sistemi için geliştirilmiş bir programlama dilidir. SQLin yeteneklerini genişleterek, prosedürel programlama özellikleri sunar. (Prosedürel programlama, bir programın adım adım işleyişini belirleyen, işlev (fonksiyon) ve prosedürler kullanarak kodu organize eden bir programlama tekniklerinin bütünüdür)

Oracle ile entegre çalışan PL/SQL, veri tabanı işlemlerini yüksek düzeyde özelleştirmeye olanak tanır. Depolanan prosedürler, fonksiyonlar, tetikleyiciler ve paketler gibi yapılandırılmış programlama araçlarıyla güçlü ve güvenilir uygulamalar geliştirilmesini sağlar.


-- SQL yapısal olarak 3 gruba ayrılır:

--1- DDL (Data Defination Language / Veri Tanımlama Dili)

CREATE - aLTER - DROP

--2- DML (Data maniplation lang. / Veri İşleme dili)

SELECT - INSERT - UPDATE - DELETE

--3- DCL (DATA control lang. / Veri kontrol dili)

REVOKE - GRANT - DENY

-----------------------------------------

/* açıklama açıklama...
www.aliosmangokcan.com
bu alan açıklama/yorum satırlarını gösterir */

--------------------------------------

::--::--:: SQL Server Veri Tipleri ::--::--::
-- Mantıksal ve İkili Veri Tipleri
bit : 0 veya 1 değerlerini saklar (true/false). 
Genellikle cinsiyet, medeni durum gibi veriler için kullanılır.
binary(n) : Sabit uzunlukta ikili (binary) veri saklar, maksimum 8000 byte.
varbinary(n | max) : Değişken uzunlukta ikili veri saklar, maksimum 2GB.

-- Karakter ve Metin Veri Tipleri
char(n) : Sabit uzunlukta alfanümerik veri saklar. (Örnek: char(15))
varchar(n | max) : Değişken uzunlukta alfanümerik veri saklar. (Örnek: varchar(15))
nvarchar(n | max) : Unicode destekli, değişken uzunlukta alfanümerik veri saklar.
text : Uzun metin verileri saklamak için kullanılır (maksimum 2GB). 
(Yerine VARCHAR(MAX) tercih edilmelidir.)

--Sayısal Veri Tipleri
int : -2,147,483,648 ile 2,147,483,647 arasında tam sayılar.
tinyint : 0 ile 255 arasında tam sayılar.
smallint : -32,768 ile 32,767 arasında tam sayılar.
bigint : -9 kentilyon ile +9 kentilyon arasında geniş aralıklı tam sayılar.
decimal(p, s) / numeric(p, s) : 38 basamağa kadar hassas ondalıklı sayılar saklar. 
(Örnek : decimal(10,2))
float(n) : Hassasiyet belirlenebilen kayan noktalı sayılar.
money / smallmoney : Para birimi değerleri saklar.

--Tarih ve Zaman Veri Tipleri
datetime : 1 Ocak 1753 - 31 Aralık 9999 tarih aralığını saklar.
smalldatetime : 1 Ocak 1900 - 6 Haziran 2079 tarih aralığını saklar.

--Özel Veri Tipleri
image : Resim, sunum, Excel dosyaları gibi ikili verileri saklar. 
(Yerine VARBINARY(MAX) tercih edilmelidir.)
uniqueidentifier : 16 byte uzunluğunda, benzersiz kimlikler (GUID) saklar.


::--::--:: CREATE komutu ::--::--::
Veri tabanı ve tablo oluşturmak için kullanılır.

create database veritabanı_adı
ON
Primary (Name=dosya_adı,
filename=fiziki_dosya_adı,  -- .mdf dosya 
size=dosya_boyutu,  --default 2MB
maxsize=maksimum_dosya_boyutu,
filegrowth=dosya_artış_miktarı) -- default 1MB
LOG ON 
(Name=dosya_adı,
filename=fiziki_dosya,   --.ldf dosya
size=dosya_boyutu,
maxsize=maks_dos_boyutu,
filegrowth=dos_art_miktarı)

--ÖRNEK 1:
create database deneme2

--ÖRNEK 2:
create database kutuphane
on
(name='kutuphane_dat',
filename='d:\kutuphane.mdf',
size=10,
maxsize=50MB,
filegrowth=5)
LOG ON
(name=okul2_log,
filename='d:\kutuphanelog.ldf',
size=5MB,
maxsize=25MB,
filegrowth=5MB)

::--::--:: Create Table ::--::--::
create table tablo_adi(
sütun1 veritipi1,
sütun2 veritipi2,
...
sütunN veritipiN) 

--ÖRNEK 3:
use deneme2 -- tek sefere mahsus

create table personel(
pers_id int not null,
adi varchar(25),
soyadi varchar(30))

--ÖRNEK 4:
create table ogrenci(
ogr_no int NOT NULL Primary Key,
ad_soyad varchar(25),
yas tinyint)

--ÖRNEK 5:
create table personel2(
pers_id int,
ad_soyad varchar(50),
sehir varchar(15),
unique(pers_id))

--ÖRNEK 6:
create table ogrenci2(
ogr_no int identity(1,3) not null,  --SEED (1)  -- increment(3)
adi varchar(25),
soyadi varchar(30),
bolum nchar(50) DEFAULT 'Bilgisayar')

--ÖRNEK 7:
create table notlar(
ogr_no int not null,
ders_kodu varchar(25) not null,
vize tinyint,
final tinyint,
constraint birlesikPK Primary Key (ogr_no,ders_kodu) )

--ÖRNEK 8:
create table notlar2(
ogr_no int,
ders_kodu varchar(5),
vize int CHECK (vize>=0),
final int CHECK (final>=0))

--ÖRNEK 9:
create table odeme(
id int,
bursiyer varchar(50),
burs int,
constraint chkburs CHECK (burs>=0 and burs<=3000))

--IN, NOT IN, LIKE Kullanımı
IN ifadesi yerine OR,
NOT IN ifadesi yerine AND

LIKE
% (yüzde işareti)  birden fazla karakteri ifade eder/gösterir.
_ (alt çizgi)  bir tek karakteri ifade eder.
[HARF] herhangi bir karakteri (kendisini ifade eder)
[^HARF] kendisi dışında (köşeli parantez içinde yazılanın haricinde)
[A-Z]   A ile Z arasında bir karakteri gösterir

--ÖRNEKLER 10:
ÖRN:  LIKE '%T%'   --> içinde T olanlar/geçenler
ÖRN: LIKE '_G%'  --> ilk karakteri G olanlar
ÖRN: LIKE '_ _ N'  --> üç farfli son harfi N
ÖRN: LIKE '[SA]%'  -->ilk harfi/karakteri S veya A olanlar
ÖRN: LIKE '%[B-K]'   --> son karakteri B ile K arasında olan
ÖRN: LIKE '[2-8][4-7]'  --> ilk hanesi 2-8, ikinci hanesi 4-7 arasında
ÖRN: LIKE '[^B-N][^MOZ][A-K]'  -->   ilk karakteri B-N arasında olmayan,
ikinci karalteri M,O veya Z olmayan, üçüncü karalteri A-K arasında olan

--ÖRNEK 11:
create table urunler(
urun_kodu varchar(4) not null,
urun_adi varchar(25) not null,
constraint chkkod CHECK (urun_kodu IN('A089','A090','A011','A111') OR 
urun_kodu LIKE 'A9[0-9][0-9]'))

ürün kodu : a089, a090, a011, a111 veya A900-A999

--ÖRNEK 12:
CREATE TABLE ogrenci (
    ogrno INT PRIMARY KEY, -- PK sütunu, NOT NULL belirtmeye gerek yok
    ad VARCHAR(50) NOT NULL,
    soyad VARCHAR(50),
    adres VARCHAR(255),
    telefon VARCHAR(11),
    email VARCHAR(100) );

CREATE TABLE kitap (
    kitapno INT PRIMARY KEY, -- PK sütunu, NOT NULL belirtmeye gerek yok
    basim_yili INT NOT NULL,
    yazar VARCHAR(50),
    kitap_adi VARCHAR(100),
    fiyat INT,
    CONSTRAINT chk_fiyat CHECK (fiyat >= 0 AND fiyat <= 5000),
    yayin_tarihi SMALLDATETIME,
    CONSTRAINT chk_basim_yili CHECK (basim_yili BETWEEN 1900 AND 2025)
);

CREATE TABLE odunc (
    ogrno INT NOT NULL,
    kitapno INT NOT NULL,
    alis_tarihi SMALLDATETIME,
    CONSTRAINT fk_ogrno FOREIGN KEY (ogrno) REFERENCES ogrenci (ogrno),
    CONSTRAINT fk_kitapno FOREIGN KEY (kitapno) REFERENCES kitap (kitapno),
    CONSTRAINT pk_odunc PRIMARY KEY (ogrno, kitapno)
);

/* referans tabloda satır silindiğinde diğer tablolardan da silinmesi veya refereans 
tabloda veriler güncellendiğinde diğer tablolarda da güncellenmesi için:
ON DELETE CASCADE, ON UPDATE CASCADE */

--ÖRNEK 13:
create table ...(
..
..
 CONSTRAINT fk_ogrno FOREIGN KEY (ogrno) REFERENCES ogrenci (ogrno)
 ON UPDATE CASCADE ON DELETE CASCADE,
 CONSTRAINT fk_kitapno FOREIGN KEY (kitapno) REFERENCES kitap (kitapno)
 ON UPDATE CASCADE ON DELETE CASCADE,
 CONSTRAINT pk_odunc PRIMARY KEY (ogrno, kitapno) )

::--::--:: ALTER ile veritabanı nesnelerinin özelliklerini değiştirme ::--::--::
--1- Tabloya sonradan sütun eklemek:
Alter table tabloadı ADD sütunadı özellik

--ÖRNEK 14:
ALTER TABLE kiralama ADD testtarihi smalldatetime not null

--2- Tabloda istenen üstünu silmek için:
ALTER TABLE tabloadı DROP COLUMN sütunadı

--ÖRNEK 15:
alter table kiralama DROP COLUMN testtarihi

--3- Tabloda sütun özelliklerini değiştirmek için:
ALTER TABLE tabloadı ALTER COLUMN sütunadı özellikleri

--ÖRNEK 16:
ALTER TABLE arac ALTER COLUMN plaka nvarchar(20)

--ÖRNEK 17:
alter table musteri add myasi int

alter table musteri add check (myasi>0)

--ÖRNEK 18:
alter table arac drop chkfiyat

alter table arac alter column fiyat float 

alter table arac add constraint chkfiyat CHECK (fiyat>=0 AND fiyat<=100000)

::--::--:: DROP ile DB veya tablo silme ::--::--::
Alter drop: db nesnelerinin özelliklerini silmek için...
drop : db nesnesi (tabloları veya db) silmek için...
Truncate -- en garantili kayıt silme için
Delete  --kayıt silme için

--ÖRNEK 19:
drop table gecici

--ÖRNEK 20:
drop database xyz   --xyz isimli db'yi siler

::--::--::--:: DML (DATA manuplation lang. / Veri işleme dili)  ::--::--::--::
Select - insert - update - delete

::--::--:: SELECT ile listeleme işlemleri ::--::--::
select sütunadı veya * from tabloadı where koşul

--ÖRNEK 21:
select * from personel
--NOT : Select örneklerinin devamı için ÖRNEK 36 ve sonrasına bakınız.

::--::--:: INSERT ile veri girişi ::--::--::
INSERT INTO tabloadı VALUES (değer1,değer2,değer3....) 

INSERT INTO tabloadı(sütun1,sütun3,sütunx..) VALUES (değer1,değer3,değerx...)

--ÖRNEK 22:
create table personel(
pers_id int not null,
ad varchar(25),
soyad varchar(50),
sehir varchar(20),
mail varchar(100),
maas int check (maas>0))

insert into personel values (1,'ali','can','van','ali@can.com',25000)

--ÖRNEK 23:
insert into personel(pers_id,ad,mail) values (3,'ahmet','ahmet@gamil.com')

--ÖRNEK 24: herkes istediği bir sütun NULL olacak şekilde kendi bilgilerini girsin.
insert into personel (pers_id, ad, soyad, mail, maas) 
VALUES (2,'Mehmet','Başaran','mehmet.basaran@mail.com', 50000)

insert into personel(pers_id,ad,soyad,mail)values(4,'utku','bolat','utkubolat@outlook.com')

insert into personel(pers_id,ad,mail,maas) values (4,'ibrahim','ibrahim@bir.com',100000)

::--::--:: UPDATE ile veri güncelleme ::--::--::
UPDATE tabloadı set sütun1=değer1, sütun2=değer2, sütunx=değerx... where koşul

--ÖRNEK 25:
update personel set sehir='Bingöl' where pers_id=3

--ÖRNEK 26:
update personel set ad='Hakkı',soyad='Bulut' where maas>50000

--ÖRNEK 27:
update personel set maas=99999 where maas is null

--ÖRNEK 28:  sirket@mail.com 
update personel set mail='sirket@mail.com'  where pers_id>4 OR not mail like '%@%'
veya
update personel set mail='sirket@mail.com'  where pers_id>4 OR mail not like '%@%'

--ÖRNEK 29: 
update personel set sehir='Afyonkarahisar' where (maas>10000 and maas<50000) or soyad like '%n'
veya
update personel set sehir='Afyonkarahisar' where soyad like '%n' or maas between 9999 and 49999 
--between sınırları dahil ediyor

::--::--:: DELETE ve TRUNCATE ile veri silme işlemi ::--::--::
DELETE from tabloadı where koşul

--ÖRNEK 30:
delete from personel where ad  like 'c%'

--ÖRNEK 31:
delete from personel  --personel tablosundaki tüm veriler silinir

--ÖRNEK 32:
truncate table personel  --personel tablosundaki tüm veriler silinir 

::--::--::--:: DCL (DATA control lang. / Veri kontrol dili)  ::--::--::--::
                       REVOKE - GRANT - DENY
GRANT: kullanıcının kayıt yapmasına ve SQL çalıştırmasına izin verir.

DENY: kullanıcıyı kısıtlar

REVOKE: izin ve kısıtlamaları kaldırır.

-- Grant {ALL veya izinler} ON {izin alanı} TO {kullanıcılar}
 --- ON ifadesi tablo için kullanılır
 ---- veritbanı düzeyinde işlem yapmak için TO ifadesi yeterli

veritabanı için: create database, create table, backup database, create view
tablo için: select, update, insert, delete
yordam için: execute

--ÖRNEKLER 33:
 grant select,update ON musteri TO şaban
 
 grant ALL ON kiralama TO rabia,yavuz
 
 grant create database TO mehmet,emin

 --ÖRNEK 34:
 deny create table TO mustafa,ali,ahmet,oya

 /*Bu komut, belirtilen kullanıcılara, yeni bir tablo oluşturmayı yasaklar. 
 Bu kullanıcılar artık CREATE TABLE komutunu kullanarak yeni tablolar oluşturamayacaklardır.*/
 
 --ÖRNEKLER 35:
 revoke update On musteri from fatih
 /*Bu komut, "musteri" tablosu üzerindeki "fatih" kullanıcısının UPDATE iznini geri çeker. 
 Artık "fatih", bu tablo üzerinde güncelleme işlemi gerçekleştiremeyecektir.*/
 
 revoke ALL from selman,furkan,betül,meryem

::--::--:: Server Seviyesi Roller ::--::--::
Bulkadmin: Bulk Insert yetkisine sahip olurlar. Başka bir veri kaynağından 
veya EXCEL den veri çekme işlemleri için kullanılır.

DBcreator: Veritabanı Create, Alter, Drop, veya veritabanı restore edebilir. 

Diskadmin: bu yetkiye sahip olanlar disk dosyalarını yöntebilir.

Processadmin: tüm processleri yönetebilir, görebilir veya KILL komutuyla processleri 
sonlandırabilir.

Public: default yetkili kullanıcı. SQL e bağalanabilir,başka bir işlem yapamaz.

securityadmin: kullanıcı yetkilendirme işlemleri yapabilir. Grant, deny, revoke...
şifreleri sıfırlayabilir..

serveradmin: sunucu genelinde yapılandırma yapabilir, sunucuyu değiştirebilir, kapatabilir

setupadmin: stored procedure işlemleri, linked server ekleyebilir, kaldırabilir.

sysadmin: En yetkin rol. database yöneticileri dışındakilere verilmemeli.

::--::--::--:: Veri Tabanı Seviyesi Roller ::--::--::--::
db_owner: veri tabanı düzeyinde en yetkin rol.

db_securityadmin: bazı özel roller için yetkilendirme yapabilir, rol üyeliğini değiştirebilir.

db_accessadmin: win oturum açma, sql server açma işlemleri için veritabanına erişim ekleyebilir

db_backupoperator: bu role sahip olanlar db yi yedekleyebilir.

db_ddladmin: ddl komutlarını çalıştıraiblir.

db_datawriter: tablolara veri girişi yapabilir

db_datareader: veri tabanındaki verileri okuyabilir

::--::--:: SELECT ile listeleme işlemleri ::--::--::
NOT: örnekler genel olarak NORTWIND veri tabanı üzerinde uygulanmıştır

--ÖRNEK 36:
select *  from customers

--ÖRNEK 37:
select contactname,city from customers

--ÖRNEK 38:
select * from customers  where customerID LIKE '%v'

--ÖRNEK 39:
select employeeID, shipaddress from orders  where employeeId>7

--ÖRNEK 40:
select orderID,shipregion,shipname from orders where orderID>10300 and orderID<10400

--ÖRNEK 41:
select * from orders where shipcountry='brazil'
veya
select * from orders where shipcountry like 'Brazil'
veya 
select * from orders where shipcountry In ('Brazil')

--ÖRNEK 42:
select ShipCity from orders where ShipCountry not like 'İtaly'
veya
select ShipCity from orders where not ShipCountry like 'İtaly'
veya
select ShipCity from orders where shipcountry not in ('italy')
veya
select ShipCity from orders where  not shipcountry in ('italy')
veya
select shipcity from orders where ShipCountry!= 'İtaly'
veya
select shipcity from orders where ShipCountry<>'İtaly'

--ÖRNEK 43:
select tc from Kargo where gon_sube='izmir' or gon_sube='trabzon'
veya
select tc from kargo where gon_sube IN  ('izmir','trabzon')

--ÖRNEK 44:
select customerId, shipname from orders where customerId like '_A%' 
or shipname like '%en%'

--ÖRNEK 45:
select gon_ad,gon_soyad from kargo where ucret<80 or gon_ad is NULL

--ÖRNEK 46:   adı üç harfli ikinci harf L VEYA soyadı G ile bitenler
select * from kargo where gon_ad like '_l_' or gon_soyad like '%g'

--ÖRNEK 47:
select tc,ucret from kargo where tc like '6%5' 

--ÖRNEK 48:
select shipcity,orderID,shipvia from orders
where shipcity='lyon' or shipcity='köln'
veya
select shipcity,orderId,ShipVia from orders
where shipcity IN ('lyon','köln')


--ÖRNEK 49:
select shipname,freight from orders where shipname like 'f%b' or (freight>=5 and freight<=55)
veya
select * from orders where Shipname= '[f-b]' or freight between 5 and  55 

--ÖRNEK 50:
select * from customers where city LIKE 'London'
veya
SELECT * FROM Customers WHERE city='London'

--ÖRNEK 51:
select customers.customerID,orders.orderID from customers,orders

--ÖRNEK 52:
select * from customers where city='Madrid' OR region is NULL

--ÖRNEK 53:
select * from customers where customerID LIKE 'FR%' 
AND country IN ('Italy','Germany')

--ÖRNEK 54:
select * from customers where customerId LIKE 'N_R%' 

::--::--::--:: distinct: tekrarlı satırları önlemek ::--::--::--::
--ÖRNEK 55:
select distinct customerID from orders 

--ÖRNEK 56:
select distinct shipcountry from orders where shipaddress like '%j%'

::--::--::--:: order by (ASC - DESC)  ::--::--::--::
--ASC kullanımı
select * from tabloadı where koşul order by referans_sütun ASC -- artan (default)
veya
select * from tabloadı where koşul order by referans_sütun -- artan

--DESC kullanımı
select * from tabloadı where koşul order by ref_sütun DESC -- azalan

--ÖRNEK 57:
select shipaddress from orders order by shipaddress ASC 
veya
select shipaddress from orders order by shipaddress
veya
select shipaddress from orders order by 1

--ÖRNEK 58:
select * from orders order by shipaddress DESC
veya
select * from orders order by 10 DESC

--ÖRNEK 59:
select shipcountry,shipcity,shipvia from orders  order by shipcountry desc,shipcity asc
veya
select shipcountry,shipcity,shipvia from orders  order by 1 desc,2

--ÖRNEK 60:
select shipcountry,shipcity,shipvia from orders order by 1 desc,2,3

::--::--::--:: sütunlar için takma isim kullanma ::--::--::--::

--ÖRNEK 61:
select shipcountry AS 'ülke' from orders
veya
select shipcountry 'ülke' from orders
veya
select shipcountry "ülke" from orders

--ÖRNEK 62:
select mad "AD", myasi+5 "YENİ YAŞ",mail from musteri

--ÖRNEK 63:
select shipcountry+'***'+shipcity 'adres' from orders

--ÖRNEK 64:
select employeeID "İŞÇİ NO",employeeID+employeeID*0.2 "ZAMLI İŞÇİ NO" from orders

--ÖRNEK 65:
select 3+5 
select 3*5 as 'çarpım'

--ÖRNEK 66:
select mad 'AD', msoyad "SOYAD",(myasi/2)+3 "YARIM" from musteri

--ÖRNEK 67:
select orderID,shipname,customerID from  orders
where freight>=50 and shipcountry IN ('spain','italy') or shipname LIKE '%o'
order by customerID

veya

select orderID,shipname,customerID from  orders
where freight>=50 and (shipcountry='spain' or shipcountry='italy') or shipname LIKE '%o'
order by 3

--ÖRNEK 68:
select orderID 'sipariş no',shipname 'kargo',customerID 'müşteri no',orderID*5 'yeni' from  orders
where freight>=50 and shipcountry IN ('spain','italy') or shipname LIKE '%o'
order by customerID

--ÖRNEK 69:
select * from musteri 
where myasi>=23 AND myasi<=28 AND madres='Ağrı' AND mkod>2 order by msoyad --msoyad Artan

--ÖRNEK 70:
select plaka,madres from musteri where madres NOT IN ('Ağrı') order by plaka DESC
veya
select plaka,madres from musteri where madres!='Ağrı' order by 1 DESC  

--ÖRNEKLER 71:
create table urunler2(
urun_no int identity(1,1) not null,
urun_adi varchar(100),
urun_fiyati float,
constraint chkfiyatt CHECK (urun_fiyati>=0 AND urun_fiyati<=1000),
urun_adedi int,
constraint chkadet CHECK (urun_adedi>=0 AND urun_adedi<=100),
islem_tarihi smalldatetime,
sevk_adresi varchar(50))

insert into urunler2 values ('Salça',3.25,100,'07.01.2019','İzmir')
insert into urunler2 values ('Pirinç',5.75,100,'06.02.2019','İzmir')
insert into urunler2 values ('Bulgur',3.30,90,'05.03.2019','Afyon')
insert into urunler2 values ('Zeytin Yağı',24.75,85,'04.04.2019','Konya')
insert into urunler2 values ('Ayçiçek Yağı',17.25,99,'03.05.2019','Aksaray')
insert into urunler2 values ('Makarna',1.77,98,'02.06.2019','Hakkari')
insert into urunler2 values ('Şehriye',1.22,100,'01.11.2019','Bursa')

select urun_fiyati+(urun_fiyati*0.25) AS "Yeni Fiyat" from urunler2

--ÖRNEK 72: substring
select SUBSTRING (urun_adi,2,3) AS '3 Harf' from urunler2

--ÖRNEK 73: 
select substring(shipname,3,5) AS 'KISALTMA' from orders  --3.karakterden itibaren 5 karakter al

--ÖRNEK 74:
select substring(shipcity,1,1)+'.'+shipcountry "AD SOYAD" from orders

--ÖRNEK 75:  RIGHT / LEFT
select RIGHT(customerID,4),customerID from orders

--ÖRNEK 76:
select LEFT (sevk_adresi,1)+'.'+urun_adi AS 'Ad Soyad' from urunler2

--ÖRNEK 77: UPPER / LOWER
select lower(customerID), UPPER(shipaddress) from orders

--ÖRNEK 78: LEN
select urun_adi,LEN(urun_adi) As "uzunluk1",
urun_adedi,LEN(urun_adedi) as "uzunluk2" from urunler2

--ÖRNEK 79: REPLACE
select shipcountry,REPLACE(shipcountry,'USA','İzmir Gültepe') 'Yeni İsim' from orders

--ÖRNEK 80: REVERSE
select REVERSE(shipcountry) as 'ters isim' from orders

--ÖRNEK 81: ABS
select ABS(-0.45) as mutlak 

--ÖRNEK 82: ROUND
select freight,ROUND(freight,1) as "yuvarlanmış" from orders

--ÖRNEK 83: POWER
select POWER (2,3) as "küp alma"

--ÖRNEK 84: SQRT
select SQRT(64)

--ÖRNEK 85: SUM
select SUM(freight) 'Toplam' from orders where shipcountry<>'Germany'

--ÖRNEK 86:
select SUM(urun_fiyati) "Toplam" from urunler2 
where islem_tarihi>='3.3.2019'

--ÖRNEK 87:
select SUM(urun_adedi) "Toplam Ürün" from urunler2 
where urun_no>2 AND urun_no<=7 AND sevk_adresi like '%a' OR sevk_adresi like '%i'

--ÖRNEK 88: AVG
select ROUND(AVG(urun_fiyati),2) as "ortalama fiyat" from urunler2

--ÖRNEK 89:  MAX / MIN
select MAX(urun_Adedi),MIN(urun_fiyati) from urunler2

--ÖRNEK 90: 
select MAX(orderdate) from orders

--ÖRNEK 91: COUNT
select COUNT(urun_adi) as "Çeşit sayısı" from urunler2

--ÖRNEK 92:
select COUNT(distinct shipcity) from orders

--ÖRNEK 93: RTRIM / LTRIM - Boşlukları kaldırmak
select RTRIM(shippostalcode) from orders

--ÖRNEK 94: CEILING (yukarı yuvarlama) - FLOOR (aşağı yuvarlama)
select freight,CEILING(freight),FLOOR(freight) from orders

--ÖRNEK 95: CURRENT_TIMESTAMP (güncel tarih ve saat bilgisi)
select CURRENT_TIMESTAMP

--ÖRNEK 96: GETDATE  (güncel tarih ve saat bilgisi)
select GETDATE()

--ÖRNEKLER 97: DATEPART ile tarih-saat bilgisinden istenen kısmı alma
select datepart(year,getdate())  --yıl bilgisi aldık
select datepart(month,getdate())  -- ay bilgisi 
select datepart(day,getdate())     --gün bilgisi 
select datepart(week,getdate())     --hafta bilgisi 

--ÖRNEKLER 98: DATEPART
select datepart(day,'2024-01-03')     --gün bilgisi (3.gün)
select datepart(quarter,'2024-01-03')     --yılın çeyreği bilgisi 

--ÖRNEKLER 99: DATENAME
select datename(month,getdate())  --ay ismini aldık/öğrendik
select datename(weekday,getdate())  --gün ismini aldık
select datename(month,'2023-12-03')   --ay ismini aldık/öğrendik
select datepart(minute,getdate())		--kaçıncı dk olduğumuzu listeledik
select datename(minute,getdate())		--kaçıncı dk olduğumuzu listeledik

--ÖRNEK 100: 
Tablo ismi arasında boşluk olduğu için köşeli paranteze alarak listeleme yapıyoruz

select * from [Order Details]

/* Öğr.Gör.Dr.Ali Osman GÖKCAN
www.aliosmangokcan.com */


